(defproject graphivac "1.1.6"
  :description "FIXME: write description"
  :url "http://example.com/FIXME"

  :dependencies [[org.clojure/clojure "1.10.0"]

                 ;; DB
                 [com.taoensso/nippy "2.14.0"]
                 [clj-time "0.15.1"]

                 ; user authentification
                 [buddy "2.0.0"];[buddy "0.10.0"]

                 ;; API
                 [yada "1.2.16"]

                 ;; error logs
                 [org.slf4j/slf4j-nop "1.7.26"]

                 ;; server
                 [aleph "0.4.6"]
                 [bidi "2.1.6"]
                 [aleph-middleware "0.2.0"]
                 [trptcolin/versioneer "0.2.0"]
                 [org.clojure/tools.cli "0.4.2"]


                 [org.clojure/tools.reader "1.3.2"]
                 ;; Cljs application


                 [instaparse "1.4.10"]
                 [org.clojure/clojurescript "1.10.520"]
                 [org.clojure/core.async "0.4.490"]
                 [re-com "2.5.0"]
                 [reagent "0.8.1"]
                 [cljsjs/react-transition-group "1.2.0-0"]
                 [venantius/accountant "0.2.4"]
                 [org.clojars.frozenlock/reagent-modals "0.2.8"]
                 [org.clojars.frozenlock/reagent-contextmenu "0.4.3"]
                 [org.clojars.frozenlock/reagent-keybindings "1.0.2"]
                 [io.hvac.vigilia/vigilia-objects "0.1.1"]
                 [cljsjs/resize-observer-polyfill "1.4.2-0"]
                 ;[cljsjs/react-color "2.13.8-0"]
                 [org.clojars.frozenlock/entanglement "0.0.4"]
                 [reanimated "0.6.1" :exclusions [cljsjs/react]]
                 [cljsjs/react "16.4.1-0"]
                 [cljsjs/react-dom "16.4.1-0"]
                 [alandipert/storage-atom "2.0.1"] ;; cross-window clipboard
                 [com.cognitect/transit-cljs "0.8.256"]
                 [cljsjs/hammer "2.0.8-0"] ;; touch pinch/pan
                 [historian "1.2.2"]
                 [cljs-ajax "0.8.0"]
                 [com.andrewmcveigh/cljs-time "0.5.2"]
                 [cljsjs/jquery "2.1.4-0"]
                 [cljsjs/moment "2.24.0-0"]
                 [org.clojars.frozenlock/query "0.2.5"]

                 [rhizome "0.2.9"]
                 [aysylu/loom "1.0.2"]


                 [ring-server "0.5.0"]
                 [ring "1.7.1"]
                 [ring/ring-defaults "0.3.2"]
                 [compojure "1.6.1"]
                 [hiccup "1.0.5"]
                 [environ "1.0.2"]]

  :plugins [[lein-environ "1.0.2"]
            [lein-ancient "0.6.15"]
            [lein-cljsbuild "1.1.5"]
            [lein-asset-minifier "0.4.5"
             :exclusions [org.clojure/clojure]]
            [rasom/lein-externs "0.1.7"]]


  :ring {:handler graphivac.handler/app}

  :min-lein-version "2.5.0"

  :main graphivac.server

  :clean-targets ^{:protect false} [:target-path
                                    [:cljsbuild :builds :app :compiler :output-dir]
                                    [:cljsbuild :builds :app :compiler :output-to]]

  :source-paths ["src/clj" "src/cljc"]
  :resource-paths ["resources" "target/cljsbuild"]

  :minify-assets
  [[:css {:source "resources/public/css/site.css"
          :target "resources/public/css/site.min.css"}]]

  :cljsbuild {:builds {:app {:source-paths ["src/cljs" "src/cljc" "env/dev/cljs"]
                             :compiler {:asset-path "/js/out"
                                        :parallel-build true
                                        :output-to "target/cljsbuild/public/js/app.js"
                                        :output-dir "target/cljsbuild/public/js/out"
                                        :source-map true
                                        :optimizations :none
                                        :recompile-dependents false
                                        :pretty-print true
                                        :main "graphivac.dev"}}
                       :min {:source-paths ["src/cljs" "src/cljc" "env/prod/cljs"]
                             :compiler
                             {:output-to "target/cljsbuild/public/js/app.js"
                              :output-dir "target/uberjar"
                              :optimizations :advanced
                              :closure-defines {"goog.DEBUG" false} ;; re-com parameter validation
                              :parallel-build true
                              :externs ["externs.js"]}}}}

  :profiles {:dev {:repl-options {;:init-ns graphivac.repl
                                  :nrepl-middleware [cider.piggieback/wrap-cljs-repl]}

                   :dependencies [[ring/ring-mock "0.4.0"]
                                  [ring/ring-devel "1.7.1"]
                                  [prone "1.6.3"]
                                  [figwheel-sidecar "0.5.20"]
                                  [nrepl "0.8.0"]
                                  [cider/piggieback "0.5.1"]
                                  [pjstadig/humane-test-output "0.10.0"]]

                   :source-paths ["env/dev/clj"]
                   :plugins [[lein-figwheel "0.5.20"]
                             [cider/cider-nrepl "0.25.3"]
                             [org.clojure/tools.namespace "0.3.0-alpha2"
                              :exclusions [org.clojure/tools.reader]]
                             [refactor-nrepl "3.1.0"]]

                   :injections [(require 'pjstadig.humane-test-output)
                                (pjstadig.humane-test-output/activate!)]

                   :figwheel {:http-server-root "public"
                              :server-port 3448
                              :nrepl-port 7003
                              :server-ip "0.0.0.0"
                              :readline false
                              :nrepl-middleware ["cider.piggieback/wrap-cljs-repl"
                                                 "cider.nrepl/cider-middleware"
                                                 "refactor-nrepl.middleware/wrap-refactor"]
                              :css-dirs ["resources/public/css"]
                              :ring-handler graphivac.handler/app}

                   :env {:dev true}}

             :uberjar {:hooks [minify-assets.plugin/hooks]
                       :source-paths ["env/prod/clj"]
                       :prep-tasks ["compile" ["cljsbuild" "once" "min"]]
                       :env {:production true}
                       :aot :all
                       :omit-source true
                       ;; :cljsbuild {:jar true
                       ;;             :builds {:app
                       ;;                      {:source-paths ["env/prod/cljs"]
                       ;;                       :compiler
                       ;;                       {:optimizations :advanced
                       ;;                        :externs ^:replace ["externs.js"]
                       ;;                        :parallel-build true
                       ;;                        :pretty-print false}
                       ;;                       }}}
                       }})
